﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_FromUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[VX_fn_FromUTC]
GO

CREATE FUNCTION [dbo].[VX_fn_FromUTC]
(
	@sourceDateTime datetime,
	@timeZoneId int
)
RETURNS datetime
AS
BEGIN
	DECLARE @newdt datetime

	IF (@sourceDateTime > 2)
	BEGIN 
		DECLARE @gmtbias float
		DECLARE @dstbias float
		DECLARE @stdmonth int
		DECLARE @stdday int
		DECLARE @dstmonth int
		DECLARE @dstday int
		DECLARE @dstactive bit

		SELECT @gmtbias = gmtbias,
			@dstbias = dstbias,
			@dstactive = dstactive,
			@stdmonth = standardmonth,
			@stdday = standardday,
			@dstmonth = dstmonth,
			@dstday = dstday
		FROM TimeZones
		WHERE id = @timeZoneId

		SET @newdt = [dbo].[VX_fn_ApplyUtcOffset](@sourceDateTime, @gmtbias, @dstbias, @stdmonth, @stdday, @dstmonth, @dstday, @dstactive)
	END
	ELSE
	BEGIN -- (@sourceDateTime =< 2), we do not convert these date, they are flag date
		SET @newdt = @sourceDateTime
	END

	-- Return the result of the function
	RETURN @newdt
END
GO